/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class OracleMessageDAOImpl
extends MessageDAOImpl {
    OracleMessageDAOImpl() throws BrokerException {
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("STORE_SESSION_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, EMPTY_BLOB() )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insert(Connection conn, String dstID, Packet message, ConsumerUID[] conUIDs, int[] states, long storeSessionID, long createdTime, boolean checkMsgExist, boolean replaycheck) throws BrokerException {
        Throwable throwable;
        PreparedStatement pstmt;
        boolean myConn;
        block40: {
            block41: {
                block38: {
                    block39: {
                        block36: {
                            block37: {
                                myConn = false;
                                pstmt = null;
                                throwable = null;
                                try {
                                    DBManager dbMgr = DBManager.getDBManager();
                                    if (!dbMgr.isOracleDriver()) {
                                        super.insert(conn, dstID, message, conUIDs, states, storeSessionID, createdTime, checkMsgExist, replaycheck);
                                        return;
                                    }
                                    if (conn == null) {
                                        conn = dbMgr.getConnection(false);
                                        myConn = true;
                                    }
                                    SysMessageID sysMsgID = message.getSysMessageID();
                                    String id = sysMsgID.getUniqueName();
                                    int size = message.getPacketSize();
                                    long txnID = message.getTransactionID();
                                    if (dstID == null) {
                                        dstID = DestinationUID.getUniqueString(message.getDestination(), message.getIsQueue());
                                    }
                                    if (checkMsgExist) {
                                        boolean hasmsg = false;
                                        try {
                                            hasmsg = this.hasMessage(conn, id);
                                        }
                                        catch (BrokerException e) {
                                            e.setSQLRecoverable(true);
                                            e.setSQLReplayCheck(replaycheck);
                                            throw e;
                                        }
                                        if (hasmsg && replaycheck) {
                                            if (conUIDs != null) {
                                                HashMap map = null;
                                                try {
                                                    map = dbMgr.getDAOFactory().getConsumerStateDAO().getStates(conn, sysMsgID);
                                                }
                                                catch (BrokerException e) {
                                                    e.setSQLRecoverable(true);
                                                    e.setSQLReplayCheck(true);
                                                    throw e;
                                                }
                                                List<ConsumerUID> cids = Arrays.asList(conUIDs);
                                                Iterator itr = map.entrySet().iterator();
                                                Map.Entry pair = null;
                                                ConsumerUID cid = null;
                                                while (itr.hasNext()) {
                                                    pair = itr.next();
                                                    cid = (ConsumerUID)pair.getKey();
                                                    int st = (Integer)pair.getValue();
                                                    for (int i = 0; i < conUIDs.length; ++i) {
                                                        if (!conUIDs[i].equals(cid) || states[i] != st) continue;
                                                        cids.remove(conUIDs[i]);
                                                    }
                                                }
                                                if (cids.size() == 0) {
                                                    this.logger.log(8, "B1430", (Object)(id + "[" + dstID + "]" + cids));
                                                    if (!myConn) break block36;
                                                    break block37;
                                                }
                                            } else {
                                                this.logger.log(8, "B1430", (Object)(id + "[" + dstID + "]"));
                                                if (!myConn) break block38;
                                                break block39;
                                            }
                                        }
                                        if (hasmsg) {
                                            throw new BrokerException(this.br.getKString("B3008", id, dstID));
                                        }
                                        try {
                                            dbMgr.getDAOFactory().getDestinationDAO().checkDestination(conn, dstID);
                                        }
                                        catch (BrokerException e) {
                                            if (e.getStatusCode() == 404) throw e;
                                            e.setSQLRecoverable(true);
                                            throw e;
                                        }
                                    }
                                    String sql = this.insertSQL;
                                    try {
                                        pstmt = DBManager.createPreparedStatement(conn, sql);
                                        if (this.fi.FAULT_INJECTION && this.fi.checkFault("ha.takeover.badsysid", null)) {
                                            this.fi.unsetFault("ha.takeover.badsysid");
                                            id = id + "abc";
                                        }
                                        pstmt.setString(1, id);
                                        pstmt.setInt(2, size);
                                        pstmt.setLong(3, storeSessionID);
                                        pstmt.setString(4, dstID);
                                        Util.setLong(pstmt, 5, txnID == 0L ? -1L : txnID);
                                        pstmt.setLong(6, createdTime);
                                        pstmt.executeUpdate();
                                        pstmt.close();
                                        sql = this.selectForUpdateSQL;
                                        pstmt = DBManager.createPreparedStatement(conn, sql);
                                        pstmt.setString(1, id);
                                        ResultSet rs = pstmt.executeQuery();
                                        rs.next();
                                        Blob blob = rs.getBlob(1);
                                        rs.close();
                                        pstmt.close();
                                        OutputStream bos = Util.OracleBLOB_getBinaryOutputStream(blob);
                                        message.writePacket(bos);
                                        bos.close();
                                        if (conUIDs != null) {
                                            dbMgr.getDAOFactory().getConsumerStateDAO().insert(conn, dstID, sysMsgID, conUIDs, states, false, false);
                                        }
                                        if (myConn) {
                                            conn.commit();
                                        }
                                    }
                                    catch (Exception e) {
                                        Exception exception = e;
                                        boolean replayck = false;
                                        try {
                                            if (!conn.getAutoCommit()) {
                                                conn.rollback();
                                            }
                                        }
                                        catch (SQLException rbe) {
                                            replayck = true;
                                            this.logger.log(32, "B4080", (Throwable)rbe);
                                        }
                                        if (e instanceof BrokerException) {
                                            throw (BrokerException)e;
                                        }
                                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)e) : e);
                                        BrokerException be = new BrokerException(this.br.getKString("B4004", id), ex);
                                        be.setSQLRecoverable(true);
                                        if (!replayck) throw be;
                                        be.setSQLReplayCheck(true);
                                        throw be;
                                    }
                                    if (!myConn) break block40;
                                    break block41;
                                }
                                catch (BrokerException e) {
                                    BrokerException brokerException = e;
                                    throw e;
                                }
                            }
                            Util.close(null, pstmt, conn, throwable);
                            return;
                        }
                        Util.close(null, pstmt, null, throwable);
                        return;
                    }
                    Util.close(null, pstmt, conn, throwable);
                    return;
                }
                Util.close(null, pstmt, null, throwable);
                return;
            }
            Util.close(null, pstmt, conn, throwable);
            return;
        }
        Util.close(null, pstmt, null, throwable);
        return;
        finally {
            if (myConn) {
                Util.close(null, pstmt, conn, throwable);
            } else {
                Util.close(null, pstmt, null, throwable);
            }
        }
    }

    @Override
    public void moveMessage(Connection conn, Packet message, DestinationUID fromDst, DestinationUID toDst, ConsumerUID[] conUIDs, int[] states) throws IOException, BrokerException {
        block19: {
            Exception myex;
            PreparedStatement pstmt;
            block17: {
                DBManager dbMgr;
                String sql;
                boolean myConn;
                int size;
                String id;
                SysMessageID sysMsgID;
                block15: {
                    block18: {
                        block16: {
                            sysMsgID = (SysMessageID)message.getSysMessageID().clone();
                            id = sysMsgID.getUniqueName();
                            size = message.getPacketSize();
                            myConn = false;
                            pstmt = null;
                            sql = this.selectForUpdateSQL;
                            myex = null;
                            dbMgr = DBManager.getDBManager();
                            if (dbMgr.isOracleDriver()) break block15;
                            super.moveMessage(conn, message, fromDst, toDst, conUIDs, states);
                            if (!myConn) break block16;
                            Util.close(null, pstmt, conn, myex);
                            break block18;
                        }
                        Util.close(null, pstmt, null, myex);
                    }
                    return;
                }
                try {
                    if (conn == null) {
                        conn = dbMgr.getConnection(false);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    pstmt.setString(1, id);
                    ResultSet rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        throw new BrokerException(this.br.getKString("B3007", id, fromDst), 404);
                    }
                    Blob blob = rs.getBlob(1);
                    rs.close();
                    pstmt.close();
                    OutputStream bos = Util.OracleBLOB_getBinaryOutputStream(blob);
                    message.writePacket(bos);
                    bos.close();
                    sql = this.updateDestinationSQL;
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    pstmt.setString(1, toDst.toString());
                    pstmt.setInt(2, size);
                    pstmt.setString(3, id);
                    pstmt.executeUpdate();
                    ConsumerStateDAO conStateDAO = dbMgr.getDAOFactory().getConsumerStateDAO();
                    conStateDAO.deleteByMessageID(conn, id);
                    if (conUIDs != null || states != null) {
                        conStateDAO.insert(conn, toDst.toString(), sysMsgID, conUIDs, states, false, false);
                    }
                    if (myConn) {
                        conn.commit();
                    }
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", (Throwable)rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)e) : e;
                        Object[] args = new Object[]{id, fromDst, toDst};
                        throw new BrokerException(this.br.getKString("B4187", args), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block19;
            }
            Util.close(null, pstmt, null, myex);
        }
    }
}

