/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.reader.ActionReportJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.AdminCommandStateJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.MultipartProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ParamsWithPayloadJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProgressStatusDTOJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProgressStatusEventJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.remote.reader.StringProprietaryReader;
import java.util.ArrayList;
import java.util.List;

public class ProprietaryReaderFactory {
    private static final List<ProprietaryReader> proprietaryReaders = new ArrayList<ProprietaryReader>(7);

    public static <T> ProprietaryReader<T> getReader(Class<T> type, String mediaType) {
        for (ProprietaryReader pr : proprietaryReaders) {
            if (!pr.isReadable(type, mediaType)) continue;
            return pr;
        }
        return null;
    }

    static {
        proprietaryReaders.add(new StringProprietaryReader());
        ActionReportJsonProprietaryReader rdr = new ActionReportJsonProprietaryReader();
        proprietaryReaders.add(rdr);
        proprietaryReaders.add(new ParamsWithPayloadJsonProprietaryReader(rdr));
        proprietaryReaders.add(new AdminCommandStateJsonProprietaryReader());
        proprietaryReaders.add(new MultipartProprietaryReader(rdr));
        proprietaryReaders.add(new ProgressStatusDTOJsonProprietaryReader());
        proprietaryReaders.add(new ProgressStatusEventJsonProprietaryReader());
    }
}

