/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.AsyncStompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompFrameMessageImpl;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class StompMessageDispatchFilter
extends BaseFilter
implements StompOutputHandler {
    protected static final String STOMP_PROTOCOL_HANDLER_ATTR = "stomp-protocol-handler";
    private Logger _logger = null;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private StompBridgeResources _sbr = null;

    public StompMessageDispatchFilter(StompServer server) {
        this._logger = server.getLogger();
        this._bc = server.getBridgeContext();
        this._jmsprop = server.getJMSConfig();
        this._sbr = server.getStompBridgeResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        BridgeContext bc = null;
        StompMessageDispatchFilter stompMessageDispatchFilter = this;
        synchronized (stompMessageDispatchFilter) {
            if (this._bc == null || this._jmsprop == null || this._logger == null || this._sbr == null) {
                if (this._logger != null) {
                    this._logger.log(Level.WARNING, "Stomp service not ready yet");
                }
                throw new IOException("Stomp service not ready yet");
            }
            bc = this._bc;
        }
        Connection conn = ctx.getConnection();
        StompProtocolHandlerImpl sph = null;
        try {
            StompFrameMessage msg = (StompFrameMessage)ctx.getMessage();
            sph = (StompProtocolHandlerImpl)ctx.getAttributes().getAttribute("STOMP_PROTOCOL_HANDLER");
            switch (msg.getCommand()) {
                case CONNECT: 
                case STOMP: {
                    sph.onCONNECT(msg, this, ctx);
                    break;
                }
                case SEND: {
                    sph.onSEND(msg, this, ctx);
                    break;
                }
                case SUBSCRIBE: {
                    AsyncStompOutputHandler soh = new AsyncStompOutputHandler(ctx, sph, bc);
                    sph.onSUBSCRIBE(msg, this, soh, ctx);
                    return ctx.getSuspendingStopAction();
                }
                case UNSUBSCRIBE: {
                    sph.onUNSUBSCRIBE(msg, this, ctx);
                    break;
                }
                case BEGIN: {
                    sph.onBEGIN(msg, this, ctx);
                    break;
                }
                case COMMIT: {
                    sph.onCOMMIT(msg, this, ctx);
                    break;
                }
                case ABORT: {
                    sph.onABORT(msg, this, ctx);
                    break;
                }
                case ACK: {
                    sph.onACK(msg, this, ctx);
                    break;
                }
                case DISCONNECT: {
                    sph.onDISCONNECT(msg, this, ctx);
                    break;
                }
                case ERROR: {
                    this.sendToClient(msg, sph, ctx);
                    break;
                }
                default: {
                    throw new IOException(((StompFrameMessageImpl)msg).getKStringX_UNKNOWN_STOMP_CMD(msg.getCommand().toString()));
                }
            }
        }
        catch (Throwable t) {
            this._logger.log(Level.SEVERE, t.getMessage(), t);
            try {
                StompFrameMessage err = sph.toStompErrorMessage("StompProtocolFilter", t, t instanceof IOException);
                this.sendToClient(err, sph, ctx);
            }
            catch (Exception e) {
                this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3001", t.toString(), e.toString()), e);
            }
        }
        return ctx.getInvokeAction();
    }

    @Override
    public void sendToClient(StompFrameMessage msg) throws Exception {
        throw new UnsupportedOperationException("sendToclient(msg)");
    }

    @Override
    public void sendToClient(StompFrameMessage msg, StompProtocolHandler sph, Object context) throws Exception {
        FilterChainContext ctx = (FilterChainContext)context;
        boolean closechannel = false;
        try {
            if (msg.getCommand() == StompFrameMessage.Command.ERROR && msg.isFatalERROR()) {
                closechannel = true;
            }
            ctx.write((Object)msg, true);
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException || e.getCause() instanceof ClosedChannelException) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS2002", msg.toString(), e.toString()));
                if (sph != null) {
                    sph.close(false);
                }
            }
            throw e;
        }
        finally {
            if (closechannel) {
                GrizzlyFuture<Closeable> f = ctx.getConnection().close();
                try {
                    f.get();
                }
                catch (Exception ee) {
                    this._logger.log(Level.WARNING, ee.getMessage(), ee);
                }
            }
        }
    }
}

